<?php
namespace App\Entity;

use \Spot\Entity as Entity;
use \Spot\EntityInterface as Entityi;
use \Spot\MapperInterface as Mapperi;

class Work extends Entity {
  protected static $table = 'works';
  protected static $mapper = 'App\Entity\Mapper\Work';

  public static function fields() {
    return [
      'camera_id'   => ['type' => 'smallint', 'primary' => TRUE],
      'work' 		=> ['type' => 'integer'],
    ];
  }

  public static function relations(Mapperi $mapper, Entityi $entity) {
    return [
      'camera' => $mapper->belongsTo($entity, 'App\Entity\Camera', 'camera_id'),
    ];
  }
}