<?php
namespace App\Entity;

use \Spot\Entity as Entity;
use \Spot\EntityInterface as Entityi;
use \Spot\MapperInterface as Mapperi;

class Localization extends Entity {
  protected static $table = 'localizations';
  protected static $mapper = 'App\Entity\Mapper\Localization';

  public static function fields() {
    return [
      'camera_id'       => ['type' => 'smallint', 'primary' => TRUE],
      'country' 		=> ['type' => 'string'],
      'countrycode'		=> ['type' => 'text'],
      'region'      	=> ['type' => 'text'],
      'city'   			=> ['type' => 'text'],
      'lat'   			=> ['type' => 'decimal'],
      'lng'   			=> ['type' => 'decimal'],
      'zip'   			=> ['type' => 'text'],
      'timezone'		=> ['type' => 'text'],
    ];
  }

  public static function relations(Mapperi $mapper, Entityi $entity) {
    return [
      'camera' => $mapper->belongsTo($entity, 'App\Entity\Camera', 'camera_id'),
    ];
  }
}
