<?php
namespace App\Entity;

use \Spot\Entity as Entity;
use \Spot\EntityInterface as Entityi;
use \Spot\MapperInterface as Mapperi;

class Camera extends Entity {
  protected static $table = 'cameras';
  protected static $mapper = 'App\Entity\Mapper\Camera';

  public static function fields() {
    return [
      'id'          	=> ['type' => 'smallint', 'autoincrement' => TRUE, 'primary' => TRUE],
      'url' 			=> ['type' => 'text'],
      'stream'   		=> ['type' => 'text'],
      'screen'      	=> ['type' => 'text'],
      'manufacturer'    => ['type' => 'text'],
    ];
  }

  public static function relations(Mapperi $mapper, Entityi $entity) {
    return [
      'localization' => $mapper->HasOne($entity, 'App\Entity\Localization', 'camera_id'),
      'tag' => $mapper->HasOne($entity, 'App\Entity\Tag', 'camera_id'),
      'work' => $mapper->HasOne($entity, 'App\Entity\Work', 'camera_id'),
      'counter' => $mapper->HasOne($entity, 'App\Entity\Counter', 'camera_id'),
    ];
  }
}
